function MixIM_discriminate_demo(varargin)
Screen('Preference', 'SkipSyncTests', 1);
% MixIM 4AFC experiment
%
% Stimuli are basis images used in SPIE 2015 paper, loaded on each trial.  
% Subjects are asked to compare two stimuli and choose from 4 choices:
% 1) materials are same & lightings are same
% 2) materials are same & lightings are different
% 3) materials are different & lightings are same
% 4) materials are different & lightings are different
% 
% press arrow keys to select from 4 options (the selection is marked red)
% press space bar to confirm and go to next trial
% press escape to quit
%
% Notes:
% - adapted from Roland Fleming's code
% - requires Psychtoolbox
% - (c) Fan Zhang, Mar 2016.
%
% DEPENDECIES: Psychtoolbox
%
% STATE: Alpha


%%%%%%%%%%%%%%%%
%RF% Parameters
disp('Setting Parameters ...')
    
if nargin < 1
    num_reps = 1;
else
    num_reps = varargin{1};
end

rand('state',sum(100*clock)); %RF% Sets random seed to be different for each subject

%FZ% Shape parameters and trial organization(material, lighting)
material = (1:4);
lighting = (1:3);
num_stims = length(material) .* length(lighting);
stimLookup = zeros(num_stims, 2);                                                                                                 
%FZ% material x lighting
% [materialPerms, lightingPerms] = meshgrid(material, lighting);
stimLookup(:, 1) = [1 2 3 4 1 2 3 4 1 2 3 4];
stimLookup(:, 2) = [1 1 1 1 2 2 2 2 3 3 3 3];

% [stimAPerms, stimBPerms] = meshgrid(1:num_stims, 1:num_stims);

% k=0; 
% for i = 1:num_stims
%     for j = 1:num_stims
%         if i <= j
%         k = k + 1;
%         As(k,1) = stimAPerms(i,j);
%         Bs(k,1) = stimBPerms(i,j);
%         end
%     end
% end

SS=[1 1;2 2;3 3;4 4;5 5; 6 6;7 7;8 8;9 9;10 10;11 11;12 12]; % 12 settings 1 same mat same light SS*6
SD=[1 5;1 9;5 9;2 6;2 10;6 10;3 7;3 11;7 11;4 8;4 12;8 12]; % 12 settings 2 same mat diff light SD*6
DS=[1 2;1 3;1 4;2 3;2 4;3 4;5 6; 5 7;5 8;6 7; 6 8; 7 8;9 10;9 11;9 12;10 11;10 12; 11 12]; % 18 settings 3 diff mat same light DS*4 DD*2
DD=[1 6;1 7;1 8;1 10;1 11;1 12;2 5;2 7;2 8;2 9;2 11;2 12;3 5;3 6;3 8;3 9;3 10;3 12;4 5;4 6;4 7;4 9;4 10;4 11;5 10;5 11;5 12;6 9;6 11;6 12;7 9;7 10;7 12;8 9;8 10;8 11]; % setting 4 diff mat diff light
pairs=[SS;SS;SS;SD;SD;SD;DS;DS;DD;SS;SS;SS;SD;SD;SD;DS;DS;DD];
As = pairs(:, 1);
Bs = pairs(:, 2);
num_trials = length(As);
trialLookup = zeros(num_trials, 7);
trialLookup(:, 1) = 1:num_trials;
trialLookup(:, 2:3) = pairs;
trialLookup(:, 4) = stimLookup(As, 1);
trialLookup(:, 5) = stimLookup(As, 2);
trialLookup(:, 6) = stimLookup(Bs, 1);
trialLookup(:, 7) = stimLookup(Bs, 2);

%FZ% Response Keys
escape = KbName('ESCAPE');
Up = KbName('Uparrow');
Down = KbName('DownArrow');
Left = KbName('LeftArrow');
Right = KbName('RightArrow');
space = KbName('Space');

%FZ% RESULTS:
results_path = 'Results';
columns = {'condOrder', 'condID', 'stimA_ID', 'stimB_ID', 'stimA_mat', 'stimA_lit', 'stimB_mat', 'stimB_lit', 'choice'};
num_columns = length(columns);
results = zeros(num_trials, num_columns, num_reps);
sorted = results;
% DissimMatrix = zeros(num_stims, num_stims, num_reps);

%FZ% Images
% sliderRad = 300;
imWidth = 954;
imHeight = 512;
resize_ratio = 0.7;
% ovalrad = 4;
disp('Loading images ...')
imblock = zeros(imHeight, imWidth, 3, num_stims, 'uint8'); 
% imblock = zeros(imHeight, imWidth, 3, num_stims); % PNG file
for cnt=1:num_stims
    material=stimLookup(cnt, 1);
    lighting=stimLookup(cnt, 2);
    filename = sprintf('MixIMStimuli/Stimulus-%d-%d.jpg', material, lighting);
    imblock(:, :, :, cnt) = imread(filename);
end
disp('done')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% RF% Subject enters initials
initials = inputdlg('Enter Subject Number or Initials', 'Subject');

try
    %%%%%%%%%%%%%%%%%%%%%%
    %RF% initialize screen
    disp('Initializing Screen ...')
    screens = Screen('Screens');
    [window, screenRect]=Screen('OpenWindow', max(screens(:)));
    sX = screenRect(3) ./ 2;
    sY = screenRect(4) ./ 2;
    lX = sX ./ 2;
    rX = sX + lX;
    leftrect = [lX-(imWidth*resize_ratio./2) sY-(imHeight*resize_ratio./2) lX+(imWidth*resize_ratio./2)-1 sY+(imHeight*resize_ratio./2)-1];
    rightrect = [rX-(imWidth*resize_ratio./2) sY-(imHeight*resize_ratio./2) rX+(imWidth*resize_ratio./2)-1 sY+(imHeight*resize_ratio./2)-1];

    white=WhiteIndex(window);
    black=BlackIndex(window);
    grey=(white+black)/2;
    Screen(window,'FillRect', black);
    Screen('Flip', window);
    HideCursor;
    Screen(window,'TextSize', 20);
    [screenXpixels, screenYpixels] = Screen('WindowSize', window);
    [xCenter, yCenter] = RectCenter(screenRect);
    for rep = 1:num_reps
        disp(sprintf('Rep %d', rep));
        %%%%%%%%%%%%%%%%%%%%%%
        %RF% Trial structure
        trialOrder = randperm(num_trials)'; %RF% creates random sequence of conds, scrambled across factors
        trials = [trialOrder, trialLookup];
        trials = sortrows(trials, 1);
        %RF% Put conditions in results table
        results(:, 1:8, rep) = trials;
 
        for trial = 1:num_trials
            rating = ceil(rand*4);
            %%%%%%%%%%%%% %% %%%%%%%%%%%%%%%%%%%%%%%%%
            %RF% Get condit ions for current trial
            stimA = trials(trial, 3);
            stimB = trials(trial, 4);

            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %RF% Load Image
            disp('Preparing image for current trial...');
            imAdata = imblock(:, :, :, stimA);
            imBdata = imblock(:, :, :, stimB);
            imA = Screen('MakeTexture', window, imAdata);
            imB = Screen('MakeTexture', window, imBdata);

            %%%%%%%%%%%%%%%%%%%%%
            %RF% Present stimulus
            disp('Presenting stimulus ...')
            
             coinflip = round(rand(1));
            if coinflip
                Screen('DrawTexture', window, imA, [], leftrect);
                Screen('DrawTexture', window, imB, [], rightrect);
            else
                Screen('DrawTexture', window, imB, [], leftrect);
                Screen('DrawTexture', window, imA, [], rightrect);
            end
%             Screen('DrawLine', window, [255 0 0], sliderMin, sliderY, sliderMax, sliderY);
%             Screen('FillOval', window, [255 0 0], ovalRect);
            
            
            Screen('TextSize', window, 20);
            DrawFormattedText(window, 'same materials same lightings', screenXpixels * 0.25, screenYpixels * 0.8, white);

            DrawFormattedText(window, 'same materials different lightings', screenXpixels * 0.25, screenYpixels * 0.9, white);

            DrawFormattedText(window, 'different materials same lightings', screenXpixels * 0.55, screenYpixels * 0.8, white);

            DrawFormattedText(window, 'different materials different lightings', screenXpixels * 0.55, screenYpixels * 0.9, white);
            
            Screen('Flip', window);

            %%%%%%%%%%%%%%%%%%%%%%
            %RF% Waiting for response
            disp('Waiting for response ...')
%             %RF% Wait for subject to release SAPCE
%             [dummy1,dummy2,buttons] = GetMouse;
            [key_pressed, dummy, key_code] = KbCheck;
%             while any(buttons) % if already down, wait for release
%                 [dummy1,dummy2,buttons] = GetMouse;
%             end
            while any(key_code) % if already down, wait for release
                [key_pressed, dummy, key_code] = KbCheck;                                   
            end
            while (1)
                [key_pressed, dummy, key_code] = KbCheck;  %RF% check keyboard
                if key_pressed
                    key = find(key_code);
                    if length(key) == 1     %RF% Ensures only one key is pressed
                        if key == escape
                            error('Experiment Aborted by Subject!')
                        end
                        if key == space
                            break;
                        end
                        if key == Up
                            while any(key_code) % wait for release
                                [key_pressed, dummy, key_code] = KbCheck;                                   
                            end                            
                            if rating ==2 || rating ==4
                            rating = rating - 1;
                            end
                        end
                        if key == Down
                            while any(key_code) % wait for release
                                [key_pressed, dummy, key_code] = KbCheck;                                   
                            end
                            if rating ==1 || rating ==3
                            rating = rating + 1;
                            end
                        end
                        if key == Right
                            while any(key_code) % wait for release
                                [key_pressed, dummy, key_code] = KbCheck;                                   
                            end
                            if rating ==1 || rating ==2
                            rating = rating + 2;
                            end
                        end
                        if key == Left
                            while any(key_code) % wait for release
                                [key_pressed, dummy, key_code] = KbCheck;                                   
                            end
                            if rating ==3 || rating ==4
                            rating = rating - 2;
                            end
                        end
                           
                    end
                end

                    if coinflip          
                        Screen('DrawTexture', window, imA, [], leftrect);
                        Screen('DrawTexture', window, imB, [], rightrect);
                    else
                        Screen('DrawTexture', window, imB, [], leftrect);
                        Screen('DrawTexture', window, imA, [], rightrect);
                    end
                    if rating == 1
                        DrawFormattedText(window, 'same materials same lightings', screenXpixels * 0.25, screenYpixels * 0.8, [255 0 0]);
                    else
                        DrawFormattedText(window, 'same materials same lightings', screenXpixels * 0.25, screenYpixels * 0.8, white);
                    end

                    if rating == 2
                        DrawFormattedText(window, 'same materials different lightings', screenXpixels * 0.25, screenYpixels * 0.9, [255 0 0]);
                    else
                        DrawFormattedText(window, 'same materials different lightings', screenXpixels * 0.25, screenYpixels * 0.9, white);   
                    end    
                    
                    if rating == 3
                        DrawFormattedText(window, 'different materials same lightings', screenXpixels * 0.55, screenYpixels * 0.8, [255 0 0]);
                    else
                        DrawFormattedText(window, 'different materials same lightings', screenXpixels * 0.55, screenYpixels * 0.8, white);   
                    end  
                    
                    if rating == 4
                        DrawFormattedText(window, 'different materials different lightings', screenXpixels * 0.55, screenYpixels * 0.9, [255 0 0]);
                    else
                        DrawFormattedText(window, 'different materials different lightings', screenXpixels * 0.55, screenYpixels * 0.9, white);   
                    end

                    DrawFormattedText(window, [num2str(trial+(rep-1)*num_trials) ' / ' num2str(num_trials*num_reps)], screenXpixels * 0.1, screenYpixels * 0.1, [255 0 0]);   
                
                    Screen('Flip', window);

            end
     
             %FZ%  record results
            results(trial, 9, rep) = rating;
              ratingMatrix(stimA, stimB, rep) = rating;
                   ratingMatrix(stimB, stimA, rep) = rating;
          
                    Screen('Close');  %RF% wipe the texture buffer containin g images to save texture memory !!
          end    
                 sorted(:, :, rep) = sortrows(results(:, :, rep), 2);
     end %R F% repetitions
    
              disp('Saving data ...')
                save(sprintf('Results/MixIM_4AFC_3L_%s_%s.mat', char(initials), date), 'results', 'columns', 'stimLookup','ratingMatrix'); 
     
            %RF% tidy up
       Priority(0);
    ShowCursor;
    Screen('CloseAll');
catch
    Screen('CloseAll');
    ShowCursor;
    Priority(0);
    rethrow(lasterror);
    disp('Saving raw data backup following error ...')
    save(sprintf('%s_%s_backup.mat', char(initials), date), 'results', 'columns');
    
end